VERSION 5.00
Begin VB.Form Date_Picker 
   AutoRedraw      =   -1  'True
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   " Calendar / Date Picker"
   ClientHeight    =   4620
   ClientLeft      =   45
   ClientTop       =   315
   ClientWidth     =   4605
   BeginProperty Font 
      Name            =   "System"
      Size            =   9.75
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   308
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   307
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Sel_Month_Yr_Frame 
      Height          =   720
      Left            =   750
      TabIndex        =   24
      Top             =   0
      Width           =   3705
      Begin VB.CommandButton Set_Today 
         Caption         =   "&Today"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   350
         Left            =   2830
         TabIndex        =   28
         ToolTipText     =   "Click to set today's date"
         Top             =   240
         Width           =   735
      End
      Begin VB.TextBox Sel_Year 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   1675
         MaxLength       =   4
         TabIndex        =   27
         ToolTipText     =   "Pick year"
         Top             =   250
         Width           =   775
      End
      Begin VB.VScrollBar Adj_Year 
         Height          =   315
         Left            =   2475
         Max             =   2000
         Min             =   2100
         TabIndex        =   26
         Top             =   255
         Value           =   2100
         Width           =   255
      End
      Begin VB.ComboBox Sel_Months 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   120
         TabIndex        =   25
         ToolTipText     =   "Pick month"
         Top             =   250
         Width           =   1450
      End
   End
   Begin VB.Frame Cal_Img_Frame 
      BackColor       =   &H00FFFFFF&
      Height          =   720
      Left            =   120
      TabIndex        =   23
      Top             =   0
      Width           =   615
      Begin VB.Line Line4 
         BorderColor     =   &H8000000F&
         BorderWidth     =   15
         X1              =   0
         X2              =   4320
         Y1              =   0
         Y2              =   0
      End
      Begin VB.Image Cal_Imgs 
         Height          =   480
         Left            =   50
         Picture         =   "DATE_P~1.frx":0000
         ToolTipText     =   "Right Click For Popup"
         Top             =   175
         Width           =   480
      End
   End
   Begin VB.Frame Date_From_Now_Frame 
      Caption         =   "Days From Now"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   710
      Index           =   0
      Left            =   2875
      TabIndex        =   6
      Top             =   750
      Width           =   1590
      Begin VB.TextBox Numerical_Input 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Index           =   0
         Left            =   120
         MaxLength       =   4
         TabIndex        =   8
         ToolTipText     =   "Type in days to jump forward to"
         Top             =   240
         Width           =   500
      End
      Begin VB.CommandButton Set_Date_From_Now 
         Caption         =   "&Set"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   350
         Index           =   0
         Left            =   720
         TabIndex        =   7
         ToolTipText     =   "Click to set days from now"
         Top             =   225
         Width           =   735
      End
   End
   Begin VB.Frame Date_From_Now_Frame 
      Caption         =   "Years From Now"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   710
      Index           =   3
      Left            =   2875
      TabIndex        =   3
      Top             =   2910
      Width           =   1590
      Begin VB.CommandButton Set_Date_From_Now 
         Caption         =   "&Set"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   350
         Index           =   3
         Left            =   720
         TabIndex        =   5
         ToolTipText     =   "Click to set years from now"
         Top             =   225
         Width           =   735
      End
      Begin VB.TextBox Numerical_Input 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Index           =   3
         Left            =   120
         MaxLength       =   4
         TabIndex        =   4
         ToolTipText     =   "Type in years to jump forward to"
         Top             =   240
         Width           =   500
      End
   End
   Begin VB.Frame Cal_Frame 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2865
      Left            =   120
      TabIndex        =   12
      Top             =   750
      Width           =   2750
      Begin VB.PictureBox Calendar_Field 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   2190
         Left            =   120
         ScaleHeight     =   142
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   163
         TabIndex        =   16
         Top             =   500
         Width           =   2500
         Begin VB.PictureBox Cell_3D 
            Appearance      =   0  'Flat
            AutoRedraw      =   -1  'True
            BackColor       =   &H80000005&
            BorderStyle     =   0  'None
            ForeColor       =   &H80000008&
            Height          =   300
            Left            =   960
            Picture         =   "DATE_P~1.frx":0C42
            ScaleHeight     =   20
            ScaleMode       =   3  'Pixel
            ScaleWidth      =   20
            TabIndex        =   30
            Top             =   240
            Visible         =   0   'False
            Width           =   300
         End
         Begin VB.PictureBox Selected_3D 
            Appearance      =   0  'Flat
            AutoRedraw      =   -1  'True
            BackColor       =   &H80000005&
            BorderStyle     =   0  'None
            ForeColor       =   &H80000008&
            Height          =   300
            Left            =   1200
            Picture         =   "DATE_P~1.frx":1136
            ScaleHeight     =   20
            ScaleMode       =   3  'Pixel
            ScaleWidth      =   20
            TabIndex        =   29
            Top             =   840
            Visible         =   0   'False
            Width           =   300
         End
         Begin VB.PictureBox Selector 
            BackColor       =   &H8000000D&
            BorderStyle     =   0  'None
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H0000FFFF&
            Height          =   240
            Left            =   1680
            ScaleHeight     =   15
            ScaleMode       =   0  'User
            ScaleWidth      =   16
            TabIndex        =   17
            Top             =   600
            Visible         =   0   'False
            Width           =   240
         End
         Begin VB.Shape Mouse_Under_Cur 
            Height          =   240
            Left            =   1560
            Top             =   240
            Visible         =   0   'False
            Width           =   240
         End
      End
      Begin VB.Frame Weekdays_Frame 
         BorderStyle     =   0  'None
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   13
         Top             =   120
         Width           =   2485
         Begin VB.Shape Shape1 
            BackColor       =   &H8000000D&
            Height          =   255
            Left            =   0
            Top             =   120
            Width           =   2485
         End
         Begin VB.Label Day_Header 
            BackStyle       =   0  'Transparent
            Caption         =   "S"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H000000FF&
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   14
            Top             =   120
            Width           =   255
         End
         Begin VB.Label Day_Header 
            AutoSize        =   -1  'True
            BackColor       =   &H8000000D&
            Caption         =   "  S   M   T   W   T   F   S  "
            DragMode        =   1  'Automatic
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            ForeColor       =   &H00FFFFFF&
            Height          =   240
            Index           =   0
            Left            =   0
            TabIndex        =   15
            ToolTipText     =   "afsdf"
            Top             =   120
            Width           =   2475
         End
      End
      Begin VB.Line Line3 
         BorderColor     =   &H80000000&
         BorderWidth     =   2
         X1              =   120
         X2              =   2640
         Y1              =   2710
         Y2              =   2710
      End
      Begin VB.Line Line2 
         BorderColor     =   &H8000000F&
         BorderWidth     =   5
         X1              =   0
         X2              =   2760
         Y1              =   45
         Y2              =   45
      End
   End
   Begin VB.Frame Date_Output_Frame 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   500
      Left            =   120
      TabIndex        =   20
      Top             =   3540
      Width           =   4365
      Begin VB.CommandButton Simplified_UI 
         Caption         =   "<"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   4090
         TabIndex        =   21
         ToolTipText     =   "Click to Simplify Interface"
         Top             =   100
         Width           =   255
      End
      Begin VB.Label Show_Date 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H000000FF&
         Height          =   255
         Left            =   50
         TabIndex        =   22
         Top             =   180
         Width           =   2400
      End
   End
   Begin VB.CommandButton OK 
      Caption         =   "&OK"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   350
      Left            =   3480
      TabIndex        =   19
      Top             =   4155
      Width           =   1005
   End
   Begin VB.CommandButton Cancel 
      Caption         =   "&Cancel"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   350
      Left            =   2400
      TabIndex        =   18
      Top             =   4155
      Width           =   1005
   End
   Begin VB.Frame Date_From_Now_Frame 
      Caption         =   "Weeks From Now"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   710
      Index           =   1
      Left            =   2875
      TabIndex        =   9
      Top             =   1455
      Width           =   1590
      Begin VB.CommandButton Set_Date_From_Now 
         Caption         =   "&Set"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   350
         Index           =   1
         Left            =   720
         TabIndex        =   11
         ToolTipText     =   "Click to set weeks from now"
         Top             =   225
         Width           =   735
      End
      Begin VB.TextBox Numerical_Input 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Index           =   1
         Left            =   120
         MaxLength       =   4
         TabIndex        =   10
         ToolTipText     =   "Type in weeks to jump forward to"
         Top             =   240
         Width           =   500
      End
   End
   Begin VB.Frame Date_From_Now_Frame 
      Caption         =   "Months From Now"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   710
      Index           =   2
      Left            =   2875
      TabIndex        =   0
      Top             =   2190
      Width           =   1590
      Begin VB.CommandButton Set_Date_From_Now 
         Caption         =   "&Set"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   350
         Index           =   2
         Left            =   720
         TabIndex        =   2
         ToolTipText     =   "Click to set months from now"
         Top             =   225
         Width           =   735
      End
      Begin VB.TextBox Numerical_Input 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Index           =   2
         Left            =   120
         MaxLength       =   4
         TabIndex        =   1
         ToolTipText     =   "Type in months to jump forward to"
         Top             =   240
         Width           =   500
      End
   End
   Begin VB.Menu mPopupSys 
      Caption         =   ""
      Visible         =   0   'False
      Begin VB.Menu Set_Colour 
         Caption         =   "Colour"
         Begin VB.Menu Background_Colour 
            Caption         =   "Background "
            Begin VB.Menu Set_Background_Col 
               Caption         =   "Red"
               Index           =   0
            End
            Begin VB.Menu Set_Background_Col 
               Caption         =   "Blue..."
               Index           =   1
            End
            Begin VB.Menu Set_Background_Col 
               Caption         =   "Green"
               Index           =   2
            End
            Begin VB.Menu Set_Background_Col 
               Caption         =   "Yellow"
               Index           =   3
            End
            Begin VB.Menu Set_Background_Col 
               Caption         =   "Black..."
               Index           =   4
            End
            Begin VB.Menu Set_Background_Col 
               Caption         =   "White"
               Index           =   5
            End
         End
         Begin VB.Menu Foreground_Colour 
            Caption         =   "Foreground"
            Begin VB.Menu Set_Foreground_Col 
               Caption         =   "Red"
               Index           =   0
            End
            Begin VB.Menu Set_Foreground_Col 
               Caption         =   "Blue..."
               Index           =   1
            End
            Begin VB.Menu Set_Foreground_Col 
               Caption         =   "Green"
               Index           =   2
            End
            Begin VB.Menu Set_Foreground_Col 
               Caption         =   "Yellow"
               Index           =   3
            End
            Begin VB.Menu Set_Foreground_Col 
               Caption         =   "Black..."
               Index           =   4
            End
            Begin VB.Menu Set_Foreground_Col 
               Caption         =   "White"
               Index           =   5
            End
         End
      End
      Begin VB.Menu Pick_Fonts 
         Caption         =   "Font..."
         Begin VB.Menu Set_Font 
            Caption         =   "Arial..."
            Index           =   0
         End
         Begin VB.Menu Set_Font 
            Caption         =   "MS Sans Serif"
            Checked         =   -1  'True
            Index           =   1
         End
         Begin VB.Menu Set_Font 
            Caption         =   "Times New Roman"
            Index           =   2
         End
         Begin VB.Menu Set_Font 
            Caption         =   "System..."
            Index           =   3
         End
         Begin VB.Menu Set_Font 
            Caption         =   "Verdana"
            Index           =   4
         End
      End
      Begin VB.Menu Bar0 
         Caption         =   "-"
      End
      Begin VB.Menu Draw_3D_Cells 
         Caption         =   "3D Cells..."
         Checked         =   -1  'True
      End
      Begin VB.Menu Show_3D_Sel 
         Caption         =   "3D Selection"
         Checked         =   -1  'True
      End
      Begin VB.Menu Show_Grid 
         Caption         =   "Display Grid..."
         Checked         =   -1  'True
      End
      Begin VB.Menu Show_Long_Date 
         Caption         =   "Show Long Date"
         Checked         =   -1  'True
      End
      Begin VB.Menu Bar2 
         Caption         =   "-"
      End
      Begin VB.Menu Close_Cal 
         Caption         =   "Close Calendar"
      End
      Begin VB.Menu Bar4 
         Caption         =   "-"
      End
   End
End
Attribute VB_Name = "Date_Picker"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

   '-----------------------------------------------------------------------------
   '~~~~  Calendar / Date Picker By Trent Jackson 2006 All rights reserved  ~~~~
   '-----------------------------------------------------------------------------
   '                                                                            '
   '          Version: eta 0.9                                                 '
   '  Project started: 05/01/07                                                 '
   '         Finished: 09/01/07                                                 '                                                  '
   ' Bugs & Enquiries: trentjackson888@bigpond.com.au                           '
   '                                                                            '
   '-----------------------------------------------------------------------------

'Locals
Dim Days_In_Year       As Integer 'Set to 365 or 366 for leap year
Dim Days_In_Months(12) As Integer 'Fixed values except for feb
Dim Grid_Dat()         As String  'Array holding all dates in current month

'Publics
Public Return_Date     As String  'Var holding full date mm-dd-yyyy
Public Return_Year     As String  '^ Year only
Public Return_Month    As String  '^ Month
Public Return_Day      As String  '^ Day

Public Set_Month       As Long    'Proc sets picker month (no intervention from user)
Public Set_Year        As Long    '^ Year
Public Set_Day         As Long    '^ Day
Public Setting_Picker  As Boolean 'Flag set when proc is setting picker date

'APIs
Private Declare Function TextOut Lib "gdi32" Alias "TextOutA" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal lpString As String, ByVal nCount As Long) As Long
Private Declare Function MoveToEx Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, lpPoint As POINTAPI) As Long
Private Declare Function LineTo Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long) As Long
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Declare Function Rectangle Lib "gdi32" (ByVal hdc As Long, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Private Declare Sub InitCommonControls Lib "comctl32.dll" ()

'BitBlt constants
Private Const DstInvert = &H550009
Private Const MergeCopy = &HC000CA
Private Const MergePaint = &HBB0226
Private Const NotSrcCopy = &H330008
Private Const NotSrcErase = (&H1100A6)
Private Const PatCopy = (&HF00021)
Private Const PatInvert = (&H5A0049)
Private Const PatPaint = (&HFB0A09)
Private Const SrcAnd = (&H8800C6)
Private Const SrcCopy = (&HCC0020)
Private Const SrcErase = (&H440328)
Private Const SrcInvert = (&H660046)
Private Const SrcPaint = (&HEE0086)

'Window Constants
Private Const WM_CLOSE = &H10
Private Const HWND_BOTTOM = 1
Private Const HWND_NOTOPMOST = -2
Private Const HWND_TOP = 0
Private Const HWND_TOPMOST = -1
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOSIZE = &H1

'Types
Private Type POINTAPI
        X As Long
        Y As Long
End Type

Private Draw_XY  As POINTAPI

Private Sub Form_Initialize()
   InitCommonControls
End Sub

Private Sub Form_Activate()
   '// Tool dialog taking foreground priority
   Set_Dialog_On_Top Me.hwnd
End Sub

Private Sub Form_Load()
   '-----------------------------------------------------------------------------
   '// Load controls with values, initialize calendar with todays date (default)
   '-----------------------------------------------------------------------------
   
   '// Show picker
   Date_Picker.Show
                                                                                                              '
   '// Total days in months (Jan to Dec)
   Days_In_Months(1) = 31
   Days_In_Months(2) = 28
   Days_In_Months(3) = 31
   Days_In_Months(4) = 30
   Days_In_Months(5) = 31
   Days_In_Months(6) = 30
   Days_In_Months(7) = 31
   Days_In_Months(8) = 31
   Days_In_Months(9) = 30
   Days_In_Months(10) = 31
   Days_In_Months(11) = 30
   Days_In_Months(12) = 31
            
   '// Add all user-selectable 12 months to combo
   Sel_Months.AddItem "January"
   Sel_Months.AddItem "February"
   Sel_Months.AddItem "March"
   Sel_Months.AddItem "April"
   Sel_Months.AddItem "May"
   Sel_Months.AddItem "June"
   Sel_Months.AddItem "July"
   Sel_Months.AddItem "August"
   Sel_Months.AddItem "September"
   Sel_Months.AddItem "October"
   Sel_Months.AddItem "November"
   Sel_Months.AddItem "December"
   
   '// Default to displaying todays date
   Set_Picker_Date (Date)
End Sub

Function Is_Leap_Year(Check_Year As Long) As Boolean
   
   '// Test for leap year (*Procedure contributed by Roger Gilchrist 10/01/07)
   If Check_Year Mod 4 = 0 Then
      Is_Leap_Year = True
      If Check_Year Mod 100 = 0 Then
         Is_Leap_Year = Check_Year Mod 400 = 0
      End If
   End If
End Function

Public Sub Blit_3D_Cells()
   
   '// (Optional) blit 3D cells in 7x6 matrix
   Dim i As Long
   Dim j As Long
   
   For j = 0 To 5
       For i = 0 To 6
           BitBlt Calendar_Field.hdc, i * 23 + 3, j * 23 + 3, 20, 20, Cell_3D.hdc, 0, 0, SrcCopy
       Next
   Next
End Sub

Private Sub Cal_Imgs_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
   '-----------------------------------------------------------------------------
   '// Event nvokes the popup menu with single right click
   '-----------------------------------------------------------------------------
   
   If Button = 2 Then
      Mouse_Under_Cur.Visible = False
      Date_Picker.PopupMenu Date_Picker.mPopupSys
   End If
End Sub

Public Sub Draw_Calendar()
   '-----------------------------------------------------------------------------
   '// Build / draw calendar onto field where user can actively select from it
   '-----------------------------------------------------------------------------
   
   Dim Print_Y      As Integer 'Contains current X-axis for printing
   Dim Print_X      As Integer 'Y-axis
   Dim Date_Num     As String  'Holds current day for the selected month
   Dim Cal_Col      As Integer 'Column in (6x7) matrix
   Dim Cal_Row      As Integer 'Row
   Dim Days_From_01 As Long    'Total days from the year 0001
   Dim Start_Day    As Long    'First day of the month
   Dim i            As Long    'General working var
   ReDim Grid_Dat(6, 7)        'Grid contents (all the dates in the month)
   
   '// From Jan 0001 to 2000 there's 730127 days (Crucial needed key to this algorithm)
   Days_From_01 = 730127
   
   '// Wipe area ready for new print / render
   Calendar_Field.Cls
   
   If Draw_3D_Cells.Checked Then
      Blit_3D_Cells
   End If
   
   Days_In_Months(2) = 28 'Assume no leap
   '// Check for leap year with currently selected year
   If Is_Leap_Year(Set_Year) Then Days_In_Months(2) = 29
   
   '// Add up total days from yr 2000 until selected yr
   For i = 2000 To Set_Year - 1
       Days_In_Year = 365     'No leap
   
   '// Check for leap
       If Is_Leap_Year(i) Then
          Days_In_Year = 366  'Leap
       End If
   
   '// Sum it all
       Days_From_01 = Days_From_01 + Days_In_Year
   Next i

   '// Add up total days until a month before the selected month
   For i = 1 To (Set_Month - 1)
       Days_From_01 = Days_From_01 + Days_In_Months(i)
   Next i

   '// Swap vars (new meaninful name with what we're about to do next)
   Start_Day = Days_From_01

   '// Dec week until we find the start day of the month
   Do While Start_Day > 7: Start_Day = Start_Day - 7: Loop

   '// Reset to 0 if > 7
   Start_Day = Start_Day Mod 7
   
   '// Starting print coords
   Print_X = (Start_Day * 23) + 5
   Print_Y = 5
   
   '// Starting col in sync with the actual first day of the month
   Cal_Col = Start_Day
   
   '// Loop through days in month (1 to total)         '
   For i = 1 To Days_In_Months(Set_Month)
   
   '// Set new row after 7 across (gird is 6x7)
       If Print_X > 160 Then                           '
          Print_Y = Print_Y + 23                       'Inc
          Print_X = 5                                  'Reset
          Cal_Row = Cal_Row + 1                        'Inc
          Cal_Col = 0                                  'Reset
       End If
              
   '// Copy var to string
       Date_Num = Trim(Str(i))
       
   '// Add space for single digit vals (center alignment)
       If Len(Date_Num) = 1 Then
          Date_Num = Space(1) & Date_Num
       End If
       
   '// Print date to feild using the TextOut API (much faster)
       TextOut Calendar_Field.hdc, Print_X, Print_Y, Date_Num, Len(Date_Num)
             
   '// Store locations in grid array for later usage (user clicks fields)
       Grid_Dat(Cal_Row, Cal_Col) = Date_Num
       
   '// Inc X-axis for printing and col pos
       Print_X = Print_X + 23
       Cal_Col = Cal_Col + 1
   Next
   
   Start_Day = Start_Day + Set_Day                     'Set start day in month
   Cal_Col = 0                                         'Reset col & row
   Cal_Row = 0                                         '
      
   '-----------------------------------------------------------------------------
   '// Here we need to locate the col & row in the grid that matches first day
   '-----------------------------------------------------------------------------
   For i = 0 To Start_Day - 1                          'Loop through
       Cal_Col = Cal_Col + 1                           'Inc col
       If Cal_Col = 7 Then                             'New row?
          Cal_Row = Cal_Row + 1                        'Inc row
          Cal_Col = 0                                  'Reset col
       End If
   Next
   
   If Show_3D_Sel.Checked Then
   '// Blit selected 3D cell
      BitBlt Calendar_Field.hdc, Cal_Col * 23 + 3, Cal_Row * 23 + 3, 20, 20, Selected_3D.hdc, 0, 0, SrcCopy
      
   '// Rectangle around it
      Rectangle Calendar_Field.hdc, Cal_Col * 23 + 3, Cal_Row * 23 + 3, 23 + Cal_Col * 23, 23 + Cal_Row * 23
      
   '// Show day inside cell
      TextOut Calendar_Field.hdc, Cal_Col * 23 + 5, Cal_Row * 23 + 5, Grid_Dat(Cal_Row, Cal_Col), Len(Grid_Dat(Cal_Row, Cal_Col))
      '//
   Else '(Show 2D selector)
      '//
   '// Position selector square to selected day in the month
      Selector.Move (Cal_Col * 23) + 5, (Cal_Row * 23) + 5
   
   '// Show date inside square
      Selector.Cls
      TextOut Selector.hdc, 1, 0, Grid_Dat(Cal_Row, Cal_Col), Len(Grid_Dat(Cal_Row, Cal_Col))
   End If
      
   '// Build return string (mm-dd-yy)
   Return_Date = Set_Month & "-" & Grid_Dat(Cal_Row, Cal_Col) & "-" & Set_Year
   Call Extract_Date_Specifics
   
   '// Update bottom portion of picker with a readout of the selected date
   Show_Date.Caption = Format(Return_Date, IIf(Show_Long_Date.Checked, "dddd, mmmm d, yyyy", "dd/mm/yyyy"))
   
   '// Reset (var only used by Set_Picker_Date proc to force a sel)
   Set_Day = 0

   '// Draw grid? (optional)
   If Show_Grid.Checked Then
      Draw_Grid
   End If
   
   Calendar_Field.Refresh
End Sub

Public Sub Draw_Grid()
   '-----------------------------------------------------------------------------
   '// Draw (7x8) grid if option is set
   '-----------------------------------------------------------------------------
   Dim i As Long
   Dim j As Long
   
   '// Vertical lines
   For i = 0 To 7
       MoveToEx Calendar_Field.hdc, 1 + (23 * i), 2, Draw_XY
       LineTo Calendar_Field.hdc, 1 + (23 * i), 140
   Next
   
   '// Horiz lines
   For i = 0 To 6
       MoveToEx Calendar_Field.hdc, 2, 1 + (i * 23), Draw_XY
       LineTo Calendar_Field.hdc, 175, 1 + (i * 23)
   Next
End Sub

Private Sub Calendar_Field_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
   '-----------------------------------------------------------------------------
   '// Mouse under cursor & Tool tips - telling user which day the mouse pointer
   '   is currently hovering over.
   '-----------------------------------------------------------------------------
   '(*Procedure contributed by Roger Gilchrist 10/01/07)
   
   Mouse_Under_Cur.Visible = False
   Calendar_Field.ToolTipText = vbNullString
   
   Dim Row_Loc  As Long
   Dim Col_Loc  As Long
   
   Dim Cur_PosX As Long
   Dim Cur_PosY As Long
   Dim Str_Day  As String
   
   Select Case X
          
          Case 5 To 20
               Col_Loc = 0
               Cur_PosX = 5
               Str_Day = "Sunday"
          
          Case 28 To 43
               Col_Loc = 1
               Cur_PosX = 28
               Str_Day = "Monday"
          
          Case 51 To 66
               Col_Loc = 2
               Cur_PosX = 51
               Str_Day = "Tuesday"
          
          Case 74 To 89
               Col_Loc = 3
               Cur_PosX = 74
               Str_Day = "Wednesday"
    
          Case 97 To 112
               Col_Loc = 4
               Cur_PosX = 97
               Str_Day = "Thursday"
               
          Case 120 To 135
               Col_Loc = 5
               Cur_PosX = 120
               Str_Day = "Friday"
    
          Case 143 To 166
               Col_Loc = 6
               Cur_PosX = 143
               Str_Day = "Saturday"
   End Select
    '//
   Select Case Y
           
          Case 5 To 20
               Row_Loc = 0
               Cur_PosY = 5
    
          Case 28 To 43
               Row_Loc = 1
               Cur_PosY = 28
           
          Case 51 To 66
               Row_Loc = 2
               Cur_PosY = 51
    
          Case 74 To 89
               Row_Loc = 3
               Cur_PosY = 74
    
          Case 97 To 112
               Row_Loc = 4
               Cur_PosY = 97
    
          Case 120 To 135
               Row_Loc = 5
               Cur_PosY = 120
   End Select

   '// Move sel cur and show date as tool tip
   If Cur_PosX <> 0 And Cur_PosY <> 0 Then
   
   '// Empty cell? (we don't want user to sel empty cells)
      If Grid_Dat(Row_Loc, Col_Loc) <> vbNullString Then
         Mouse_Under_Cur.Move Cur_PosX, Cur_PosY
         Mouse_Under_Cur.Visible = True
         Calendar_Field.ToolTipText = Str_Day & Space(1) & Grid_Dat(Row_Loc, Col_Loc)
      End If
   End If
End Sub

Private Sub Day_Header_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
   '-----------------------------------------------------------------------------
   '// Tool tips - telling user the abreviation of each day, M = Monday etc...
   '-----------------------------------------------------------------------------
   
   Select Case X
          Case 50 To 200
               Day_Header(Index).ToolTipText = "Sunday"
   
          Case 450 To 600
               Day_Header(Index).ToolTipText = "Monday"
   
          Case 800 To 950
               Day_Header(Index).ToolTipText = "Tuesday"
   
          Case 1100 To 1350
               Day_Header(Index).ToolTipText = "Wednesday"
          
          Case 1500 To 1650
               Day_Header(Index).ToolTipText = "Thursday"
   
          Case 1850 To 2000
               Day_Header(Index).ToolTipText = "Friday"
   
          Case 2150 To 2300
               Day_Header(Index).ToolTipText = "Saturday"
   End Select
End Sub

Private Sub Calendar_Field_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
   '-----------------------------------------------------------------------------
   '// Mouse-driven event envokes popup menu with right click, event also allows
   '   user to select a date within the calendar grid.
   '-----------------------------------------------------------------------------
   
   '// Hide hover over boarder
   Mouse_Under_Cur.Visible = False
   
   '// Right click for popup?
   If Button = 2 Then
      Date_Picker.PopupMenu Date_Picker.mPopupSys
      Exit Sub '(must bail out in case user aborts sel in popup)
   End If
   
   Calendar_Field.ToolTipText = vbNullString
   
   Dim Row_Loc   As Long
   Dim Col_Loc   As Long
   Dim Cur_PosX  As Long
   Dim Cur_PosY  As Long
   Dim Str_Day   As String
   
   Select Case X
          
          Case 5 To 20
               Col_Loc = 0
               Cur_PosX = 5
               Str_Day = "Sunday"

          Case 28 To 43
               Col_Loc = 1
               Cur_PosX = 28
               Str_Day = "Monday"
          
          Case 51 To 66
               Col_Loc = 2
               Cur_PosX = 51
               Str_Day = "Tuesday"
          
          Case 74 To 89
               Col_Loc = 3
               Cur_PosX = 74
               Str_Day = "Wednesday"
    
          Case 97 To 112
               Col_Loc = 4
               Cur_PosX = 97
               Str_Day = "Thursday"
               
          Case 120 To 135
               Col_Loc = 5
               Cur_PosX = 120
               Str_Day = "Friday"
    
          Case 143 To 166
               Col_Loc = 6
               Cur_PosX = 143
               Str_Day = "Saturday"
   End Select
    '//
   Select Case Y
           
          Case 5 To 20
               Row_Loc = 0
               Cur_PosY = 5
    
          Case 28 To 43
               Row_Loc = 1
               Cur_PosY = 28
           
          Case 51 To 66
               Row_Loc = 2
               Cur_PosY = 51
    
          Case 74 To 89
               Row_Loc = 3
               Cur_PosY = 74
    
          Case 97 To 112
               Row_Loc = 4
               Cur_PosY = 97
    
          Case 120 To 135
               Row_Loc = 5
               Cur_PosY = 120
   End Select

   If Cur_PosX <> 0 And Cur_PosY <> 0 Then
      If Grid_Dat(Row_Loc, Col_Loc) <> vbNullString Then 'User click on valid area? (inside a cell w/num)
   
   '// Show 3D selection? (optional)
         If Show_3D_Sel.Checked Then
            Calendar_Field.Cls
      
   '// Draw 3D cells? (optional)
            If Draw_3D_Cells.Checked Then
               Call Blit_3D_Cells
            End If
      
            Dim i As Long
            Dim j As Long
      
   '// Draw grid? (optional)
            If Show_Grid.Checked Then
               Draw_Grid
            End If
      
   '// Print out current calendar (no need to re-build it)
            For i = 0 To 5
                For j = 0 To 6
                    TextOut Calendar_Field.hdc, j * 23 + 5, i * 23 + 5, Grid_Dat(i, j), Len(Grid_Dat(i, j))
                Next
            Next
   
   '// Blit selected cell and place black rectangle around it
            BitBlt Calendar_Field.hdc, Col_Loc * 23 + 3, Row_Loc * 23 + 3, 20, 20, Selected_3D.hdc, 0, 0, SrcCopy
            Rectangle Calendar_Field.hdc, Col_Loc * 23 + 3, Row_Loc * 23 + 3, 23 + Col_Loc * 23, 23 + Row_Loc * 23
      
   '// Print day in selected cell
            TextOut Calendar_Field.hdc, Col_Loc * 23 + 5, Row_Loc * 23 + 5, Grid_Dat(Row_Loc, Col_Loc), Len(Grid_Dat(Row_Loc, Col_Loc))
   
   '// Refresh new render
            Calendar_Field.Refresh
         
         Else '(3D look disabled) show selection using blue pic box
   
  '// Show selected date inside of selector pic box & reposition selector square
            Selector.Move (Col_Loc * 23) + 5, (Row_Loc * 23) + 5
            Selector.Cls
            TextOut Selector.hdc, 1, 0, Grid_Dat(Row_Loc, Col_Loc), Len(Grid_Dat(Row_Loc, Col_Loc))
         End If
   
   '// Build main return string (mm-dd-yy)
         Return_Date = Set_Month & "-" & Grid_Dat(Row_Loc, Col_Loc) & "-" & Set_Year
      
   '// Seperate day, month & year into return vars
         Call Extract_Date_Specifics
      
   '// Update bottom portion of picker with a readout of the selected date
         Show_Date.Caption = Format(Return_Date, IIf(Show_Long_Date.Checked, "dddd, mmmm d, yyyy", "dd/mm/yyyy"))
      End If
   End If
End Sub

Private Sub Selector_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
   '-----------------------------------------------------------------------------
   '// Event also invokes the popup menu when right click ocurs over the
   '   selected date in the calendar.
   '-----------------------------------------------------------------------------
   
   If Button = 2 Then
      Mouse_Under_Cur.Visible = False
      Date_Picker.PopupMenu Date_Picker.mPopupSys
   End If
End Sub

Private Sub Selector_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
   '-----------------------------------------------------------------------------
   '// Tool tips - tell user which day the pointer is currently under.
   '-----------------------------------------------------------------------------
   '(*Procedure contributed by Roger Gilchrist 10/01/07)
   
   Dim Row_Loc      As Long
   Dim Col_Loc      As Long
   Dim Str_Day      As String

   Selector.ToolTipText = vbNullString
   Mouse_Under_Cur.Visible = False
    
   Select Case Selector.Left
          
          Case 5 To 20
               Col_Loc = 0
               Str_Day = "Sunday"
          
          Case 28 To 43
               Col_Loc = 1
               Str_Day = "Monday"
          
          Case 51 To 66
               Col_Loc = 2
               Str_Day = "Tuesday"
          
          Case 74 To 89
               Col_Loc = 3
               Str_Day = "Wednesday"
    
          Case 97 To 112
               Col_Loc = 4
               Str_Day = "Thursday"
    
          Case 120 To 135
               Col_Loc = 5
               Str_Day = "Friday"
    
          Case 143 To 166
               Col_Loc = 6
               Str_Day = "Saturday"
    End Select
    '//
    Select Case Selector.Top
           
          Case 5 To 20
               Row_Loc = 0
    
          Case 28 To 43
               Row_Loc = 1
           
          Case 51 To 66
               Row_Loc = 2
    
          Case 74 To 89
               Row_Loc = 3
    
          Case 97 To 112
               Row_Loc = 4
    
          Case 120 To 135
               Row_Loc = 5
    End Select

    If Grid_Dat(Row_Loc, Col_Loc) <> vbNullString Then
       Mouse_Under_Cur.Visible = True
       Selector.ToolTipText = Str_Day & Space$(1) & Grid_Dat(Row_Loc, Col_Loc)
    End If
End Sub

Private Sub Sel_Year_Change()
   '-----------------------------------------------------------------------------
   '// Manual key entry year sel, auto yeild when there's the 4 required chr's
   '-----------------------------------------------------------------------------
   If Len(Sel_Year.Text) = 4 And Not Setting_Picker Then
   
   '// Check selection integrity
      If Val(Trim(Sel_Year.Text)) < 2000 Or Val(Trim(Sel_Year.Text)) > 2100 Then
         MsgBox "Valid range is (2000 - 2100)", vbOKOnly, "Invalid Year Selected"
         Sel_Year.Text = "2000"
      Else
   
   '// Apply sel, update cal
         Set_Year = Val(Trim(Sel_Year.Text))
         Adj_Year.Value = Set_Year
         Call Draw_Calendar
      End If
   End If
End Sub

Private Sub Adj_Year_Change()
   
   '// Apply sel, update cal
   If Not Setting_Picker Then                          'User invoke only
      Set_Year = Adj_Year.Value                        '
      Sel_Year.Text = Adj_Year.Value
      Call Draw_Calendar
   End If
End Sub

Private Sub Sel_Months_Click()
   
   '// User sel new month from drop down combo
   If Not Setting_Picker Then                          'User invoke only
      Set_Month = Sel_Months.ListIndex + 1
      Call Draw_Calendar
   End If
End Sub

Private Sub Sel_Year_KeyPress(KeyAscii As Integer)
   
   '// Ensure numerical values only
   If Not ((KeyAscii >= Asc("0") And KeyAscii <= Asc("9"))) Then
      If KeyAscii <> 8 Then                            'Allow backspace
         KeyAscii = 0                                  'Force to zero
      End If                                           '(Field  will not update)
   End If
End Sub

Private Sub Numerical_Input_KeyPress(Index As Integer, KeyAscii As Integer)
   
   '// Allow user to press the enter key to apply val
   If KeyAscii = vbKeyReturn Then
      Call Set_Date_From_Now_Click(Index)
   End If
   
   '// Ensure numerical values only
   If Not ((KeyAscii >= Asc("0") And KeyAscii <= Asc("9"))) Then
      If KeyAscii <> 8 Then                            'Allow backspace
         KeyAscii = 0                                  'Force to zero
      End If                                           '(Field  will not update)
   End If
End Sub

Public Sub Set_Date_From_Now_Click(Index As Integer)
    
    '// Add defined num of days, weeks, months OR years to current date
    '(*Procedure contributed by Roger Gilchrist 10/01/07)
    Dim Array_Unit     As Variant
    Dim Array_Unit_Err As Variant

    Array_Unit = Array("d", "ww", "m", "yyyy")
    Array_Unit_Err = Array("days", "weeks", "months", "years") '<<<<<<<<This just supports multiple error messages

    If Not Set_Picker_Date(DateAdd(Array_Unit(Index), Val(Trim$(Numerical_Input(Index).Text)), Return_Date)) Then
        MsgBox "Failed to add num of " & Array_Unit_Err(Index) & " from now.", vbOKOnly, "Date Picker Error"
    End If
End Sub

Private Sub Set_Font_Click(Index As Integer)
    
    '(*Procedure contributed by Roger Gilchrist 10/01/07)
    Dim i As Long
    
    '// Remove ticks
    For i = 0 To 4
        Set_Font(i).Checked = False
    Next
    
    '// Place new tick denoting selection
    Set_Font(Index).Checked = True
    
    On Error GoTo Failed_Set
    
    Select Case Index
           Case 0 'Arial...
                Calendar_Field.FontName = "Arial"
    
           Case 1 'MS Sans Serif
                Calendar_Field.FontName = "MS Sans Serif"
    
           Case 2 'Times New Roman
                Calendar_Field.FontName = "Times New Roman"
    
           Case 3 'System...
                Calendar_Field.FontName = "System"
    
           Case 4 'Verdana
                Calendar_Field.FontName = "Verdana"
    End Select
    
    Selector.FontName = Calendar_Field.FontName
    Set_Picker_Date (Return_Date)
    Exit Sub

'//////////
Failed_Set:
'\\\\\\\\\\
    MsgBox "The specified font may not be installed" & vbNewLine & _
       "on your system...", vbOKOnly, "Can't Set Font"
    Err.Clear
End Sub

Private Sub Set_Background_Col_Click(Index As Integer)
        
    '(*Procedure contributed by Roger Gilchrist 10/01/07)
    Dim i As Long
    
    '// Remove ticks
    For i = 0 To 5
        Set_Background_Col(i).Checked = False
    Next
        
    '// Place new tick denoting selection
    Set_Background_Col(Index).Checked = True
    
    '// Apply new col accordingly
    Select Case Index
           Case 0 'Red
                Calendar_Field.BackColor = vbRed
    
           Case 1 'Blue...
                Calendar_Field.BackColor = vbBlue
           
           Case 2 'Green
                Calendar_Field.BackColor = vbGreen
           
           Case 3 'Yellow
                Calendar_Field.BackColor = vbYellow
    
           Case 4 'Black...
                Calendar_Field.BackColor = vbBlack
    
           Case 5 'White
                Calendar_Field.BackColor = vbWhite
    End Select
    
    '// Refresh
    Set_Picker_Date (Return_Date)
End Sub

Private Sub Set_Foreground_Col_Click(Index As Integer)
        
    '(*Procedure contributed by Roger Gilchrist 10/01/07)
    Dim i As Long
    
    '// Remove ticks
    For i = 0 To 5
        Set_Foreground_Col(i).Checked = False
    Next
        
    '// Place new tick denoting selection
    Set_Foreground_Col(Index).Checked = True
    
    '// Apply new col accordingly
    Select Case Index
           Case 0 'Red
                Calendar_Field.ForeColor = vbRed
    
           Case 1 'Blue...
                Calendar_Field.ForeColor = vbBlue
           
           Case 2 'Green
                Calendar_Field.ForeColor = vbGreen
           
           Case 3 'Yellow
                Calendar_Field.ForeColor = vbYellow
    
           Case 4 'Black...
                Calendar_Field.ForeColor = vbBlack
    
           Case 5 'White
                Calendar_Field.ForeColor = vbWhite
    End Select
    
    '// Refresh
    Set_Picker_Date (Return_Date)
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
      Mouse_Under_Cur.Visible = False
End Sub

Private Sub Date_From_Now_Frame_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
      Mouse_Under_Cur.Visible = False
End Sub

Private Sub Set_Today_Click()
   '// Display current system date
    Set_Picker_Date (Date)
End Sub

Public Sub Extract_Date_Specifics()
   '-----------------------------------------------------------------------------
   '// Extract year, month & day
   '-----------------------------------------------------------------------------
   Return_Year = Year(Return_Date)
   Return_Month = Month(Return_Date)
   Return_Day = Day(Return_Date)
End Sub

Public Function Set_Picker_Date(ByVal Picker_Date As Date) As Boolean
   '-----------------------------------------------------------------------------
   Setting_Picker = True
   '// Set flag that tells the controls on the UI not to update the Calendar
   '   Without this, the calendar will be update an undesirable num of times.
   '   Due to, because mutltiple controls all containing the call.
   '-----------------------------------------------------------------------------

On Error GoTo Set_Date_Failed
   
   '// Extract year, month & day from date
   Set_Year = Year(Picker_Date)
   Set_Month = Month(Picker_Date)
   Set_Day = Day(Picker_Date) - 1
   
   '// Update UI controls with new date specifics
   Date_Picker.Sel_Year.Text = Trim(Str(Set_Year))
   Date_Picker.Adj_Year.Value = Set_Year
   Date_Picker.Sel_Months.ListIndex = (Set_Month - 1)
   
   '// Update calendar grid with new month
   Call Date_Picker.Draw_Calendar
   
   Setting_Picker = False                  'Reset flag
   Set_Picker_Date = True                  'Set
   Exit Function                           'Bail out
   
'///////////////
Set_Date_Failed:
'\\\\\\\\\\\\\\\
   Err.Clear
   Setting_Picker = False                  'Reset
   Set_Picker_Date = False                 'Fail set
End Function

Private Sub Show_3D_Sel_Click()
   
   '// Toggle tick
   Show_3D_Sel.Checked = Not (Show_3D_Sel.Checked)
   
   '// Hide / show cursor square
   Selector.Visible = IIf(Not Show_3D_Sel.Checked, True, False)
   
   '// Refresh new render
   Set_Picker_Date (Return_Date)
End Sub

Private Sub Draw_3D_Cells_Click()
   
   '// Toggle tick
   Draw_3D_Cells.Checked = Not (Draw_3D_Cells.Checked)

   '// Refresh new render
   Set_Picker_Date (Return_Date)
End Sub

Private Sub Show_Grid_Click()
   
   '// Toggle tick / refresh calendar
   Show_Grid.Checked = Not (Show_Grid.Checked)
   Set_Picker_Date (Return_Date)
End Sub

Private Sub Show_Long_Date_Click()
   
   '// Toggle tick / refresh date readout
   Show_Long_Date.Checked = Not Show_Long_Date.Checked
   Show_Date.Caption = Format(Return_Date, IIf(Show_Long_Date.Checked, "dddd, mmmm d, yyyy", "dd/mm/yyyy"))
End Sub

Private Sub Simplified_UI_Click()
   
   Dim i As Long
   
   Select Case Simplified_UI.Caption
          Case "<"
                    Date_Picker.Width = 3075
                          Cancel.Left = 52
                              OK.Left = 125
              Date_Output_Frame.Width = 184
                   Simplified_UI.Left = 2490
              Sel_Month_Yr_Frame.Left = 8
             Sel_Month_Yr_Frame.Width = 183
                       Sel_Year.Width = 675
                        Adj_Year.Left = 2375
                Simplified_UI.Caption = ">"
            Simplified_UI.ToolTipText = "Click to Restore Full Interface"
                    Set_Today.Visible = False
                Cal_Img_Frame.Visible = False
               
               For i = 0 To 3
                   Date_From_Now_Frame(i).Visible = False
               Next
               
          Case ">"
                    Date_Picker.Width = 4700
                          Cancel.Left = 160
                              OK.Left = 232
              Date_Output_Frame.Width = 291
                   Simplified_UI.Left = 4080
              Sel_Month_Yr_Frame.Left = 50
             Sel_Month_Yr_Frame.Width = 247
                       Sel_Year.Width = 775
                        Adj_Year.Left = 2475
                Simplified_UI.Caption = "<"
            Simplified_UI.ToolTipText = "Click to Simplify Interface"
                    Set_Today.Visible = True
                Cal_Img_Frame.Visible = True
                
               For i = 0 To 3
                   Date_From_Now_Frame(i).Visible = True
               Next
               
   End Select
End Sub

Public Sub Set_Dialog_On_Top(hwnd As Long)
   '// Dialog w/ foreground priority
   SetWindowPos hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE
End Sub

Public Sub Set_Dialog_Not_On_Top(hwnd As Long)
   '// Resume w/out
   SetWindowPos hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE
End Sub

Private Sub Cancel_Click()
   '// Insert the required code to suit application
   Me.Hide
End Sub

Private Sub OK_Click()
   '// Insert the required code to suit application
   Me.Hide
End Sub

Private Sub Close_Cal_Click()
   '// Insert the required code to suit application
   Unload Me
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Set Date_Picker = Nothing
End Sub

